/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.testing;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.test.VocableListTesterLogic;
import de.duehl.vocabulary.japanese.tools.VocableListShuffler;
import de.duehl.vocabulary.japanese.ui.components.VocableTester;
import de.duehl.vocabulary.japanese.ui.components.data.VocableTestReactor;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.testing.AllTranslationsEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.testing.TranslationEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.testing.VocableAfterTypingErrorSelectorDialog;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class VocableListTesterDialog
extends ModalDialogBase
implements VocableTestReactor {
    private final List<Vocable> vocables;
    private final String testTitle;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final VocableTester vocableTester;
    private final JButton quitButton;
    private final StringSelection numberOfVocablesSelection;
    private final StringSelection numberOfDoneVocablesSelection;
    private final StringSelection numberOfCorrectDoneVocablesSelection;
    private final StringSelection correctDonePercentVocablesSelection;
    private int numberOfDoneVocables;
    private int numberOfCorrectDoneVocables;
    private int indexOfShownVocable;
    private final VocableListTesterLogic logic;
    private final double lastTenTestsPercentBefore;

    public VocableListTesterDialog(List<Vocable> list, String string, VocableListTesterLogic vocableListTesterLogic, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        super(fumikoUiObjects.getGuiLocation(), fumikoUiObjects.getProgramImage(), VocableListTesterDialog.createDialogTitle(list, string, fumikoDataStructures));
        this.testTitle = string;
        this.logic = vocableListTesterLogic;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        Options options = fumikoDataStructures.getOptions();
        VocablesShuffleType vocablesShuffleType = options.getVocablesShuffleType();
        VocableListShuffler vocableListShuffler = new VocableListShuffler(list, vocablesShuffleType, fumikoDataStructures);
        vocableListShuffler.shuffle();
        this.vocables = vocableListShuffler.getVocables();
        this.vocableTester = new VocableTester(this, options);
        this.quitButton = new JButton();
        this.numberOfVocablesSelection = new StringSelection("Anzahl abzufragender Vokabeln");
        this.numberOfDoneVocablesSelection = new StringSelection("Anzahl bereits abgefragter Vokabeln");
        this.numberOfCorrectDoneVocablesSelection = new StringSelection("Anzahl korrekt beantworteter Vokabeln");
        this.correctDonePercentVocablesSelection = new StringSelection("Prozent korrekt beantworteter Vokabeln");
        this.lastTenTestsPercentBefore = VocabularyTrainerUiTools.createLastTenTestsPercent(list, fumikoDataStructures);
        this.fillDialog();
    }

    private static String createDialogTitle(List<Vocable> list, String string, FumikoDataStructures fumikoDataStructures) {
        return VocabularyTrainerUiTools.generateTitleWithVocabularyTestSuccesss(list, string, fumikoDataStructures);
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        this.showFirstVocable();
        this.keybindingsForPlaySound();
    }

    private void initElements() {
        SelectionsHelper.initSelectionAsViewer(this.numberOfVocablesSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfDoneVocablesSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfCorrectDoneVocablesSelection);
        SelectionsHelper.initSelectionAsViewer(this.correctDonePercentVocablesSelection);
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSummeryPart(), "North");
        jPanel.add(this.createVocabularyPart(), "Center");
        return jPanel;
    }

    private Component createSummeryPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 3, 3));
        jPanel.add(this.numberOfVocablesSelection.getPanel());
        jPanel.add(this.numberOfDoneVocablesSelection.getPanel());
        jPanel.add(this.numberOfCorrectDoneVocablesSelection.getPanel());
        jPanel.add(this.correctDonePercentVocablesSelection.getPanel());
        return jPanel;
    }

    private Component createVocabularyPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.vocableTester.getPanel());
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPlaySoundKeyCombinationLabel(), "West");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createPlaySoundKeyCombinationLabel() {
        JLabel jLabel = new JLabel("Abspielen mit F9");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    private void keybindingsForPlaySound() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(120, 0);
        String string = "F9";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.vocableTester.playMp3());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private Component createQuitButton() {
        this.quitButton.setText("Abbrechen");
        this.quitButton.addActionListener(actionEvent -> this.quit());
        return this.quitButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private void showFirstVocable() {
        this.numberOfVocablesSelection.setText(NumberString.taupu(this.vocables.size()));
        this.numberOfDoneVocables = 0;
        this.numberOfCorrectDoneVocables = 0;
        this.setNumbersAndPercent();
        this.indexOfShownVocable = 0;
        this.showVocable(this.vocables.get(this.indexOfShownVocable));
    }

    public void setNumbersAndPercent() {
        this.numberOfDoneVocablesSelection.setText(NumberString.taupu(this.numberOfDoneVocables));
        this.numberOfCorrectDoneVocablesSelection.setText(NumberString.taupu(this.numberOfCorrectDoneVocables));
        if (this.numberOfDoneVocables == 0) {
            this.correctDonePercentVocablesSelection.setText("0.00 %");
        } else {
            this.correctDonePercentVocablesSelection.setText(NumberString.percent(this.numberOfCorrectDoneVocables, this.numberOfDoneVocables) + " %");
        }
    }

    @Override
    public void userEnteredJapaneseToGermanTranslation(String string, String string2, String string3) {
        this.logic.userEnteredJapaneseToGermanTranslation(string, string2, string3);
    }

    @Override
    public void userEnteredGermanToJapaneseTranslation(String string, String string2) {
        this.logic.userEnteredGermanToJapaneseTranslation(string, string2);
    }

    public void increaseNumberOfDoneVocables() {
        ++this.numberOfDoneVocables;
    }

    public void increaseNumberOfCorrectDoneVocables() {
        ++this.numberOfCorrectDoneVocables;
    }

    public boolean informAboutTranslationSuccess(List<Vocable> list, boolean bl, Vocable vocable) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        if (bl) {
            arrayList.add(vocable);
        } else {
            arrayList.addAll(list);
        }
        Options options = this.dataStructures.getOptions();
        TranslationEvaluationDialog translationEvaluationDialog = new TranslationEvaluationDialog(arrayList, bl, options.getTranslationDirection(), this.dataStructures, this.uiObjects, this.getLocation());
        translationEvaluationDialog.setVisible(true);
        if (bl) {
            return false;
        }
        return translationEvaluationDialog.wasOnlyTypingError();
    }

    @Override
    public void switchToNextVocable() {
        if (this.indexOfShownVocable < this.vocables.size() - 1) {
            ++this.indexOfShownVocable;
            this.showVocable(this.vocables.get(this.indexOfShownVocable));
            if (this.indexOfShownVocable == this.vocables.size() - 1) {
                this.quitButton.setText("Beenden");
            }
        } else {
            this.vocableTester.disable();
            SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
            double d = VocabularyTrainerUiTools.createLastTenTestsPercent(this.vocables, this.dataStructures);
            String string = VocableListTesterDialog.createDialogTitle(this.vocables, this.testTitle, this.dataStructures);
            Options options = this.dataStructures.getOptions();
            AllTranslationsEvaluationDialog allTranslationsEvaluationDialog = new AllTranslationsEvaluationDialog(options, this.numberOfDoneVocables, this.numberOfCorrectDoneVocables, this.getLocation(), this.getProgramImage(), this.lastTenTestsPercentBefore, d, string);
            allTranslationsEvaluationDialog.setVisible(true);
            if (this.indexOfShownVocable == this.vocables.size() - 1) {
                this.closeDialog();
            }
        }
    }

    private void showVocable(Vocable vocable) {
        boolean bl = this.indexOfShownVocable + 1 == this.vocables.size();
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        this.vocableTester.showVocable(vocable, internalAdditionalVocableData, bl);
        this.getRealDialog().pack();
    }

    public Vocable letUserSelectMatchingVocableForHisTranslation(String string, List<Vocable> list) {
        VocableAfterTypingErrorSelectorDialog vocableAfterTypingErrorSelectorDialog = new VocableAfterTypingErrorSelectorDialog(string, list, this.dataStructures, this.uiObjects, this.getLocation());
        vocableAfterTypingErrorSelectorDialog.setVisible(true);
        if (vocableAfterTypingErrorSelectorDialog.hasUserSelected()) {
            return vocableAfterTypingErrorSelectorDialog.getCorrectVocable();
        }
        GuiTools.informUser(this.quitButton, "Abbruch bei der Auswahl", "Da die Auswahl abgebrochen wurde, schreiben wir die richige \u00dcbersetzung der ersten angezeigten Vokabel gut.");
        return list.get(0);
    }

    @Override
    public boolean doWeHaveToReactOnEmptyTranslation() {
        return this.logic.doWeHaveToReactOnEmptyTranslation();
    }
}

