/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related;

import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related.VerbsAndAdjectivesFinder;
import java.awt.Component;
import javax.swing.JButton;

class VerbAndAdjectiveButtonsCreator {
    private final Vocable vocable;
    private final VerbsAndAdjectivesFinder verbsAndAdjectivesFinder;

    public VerbAndAdjectiveButtonsCreator(Vocable vocable, VerbsAndAdjectivesFinder verbsAndAdjectivesFinder) {
        this.vocable = vocable;
        this.verbsAndAdjectivesFinder = verbsAndAdjectivesFinder;
    }

    public Component createFindRelatedVerbsButton() {
        JButton jButton = new JButton("Liste von zugeh\u00f6rigen Verbformen anzeigen.");
        jButton.addActionListener(actionEvent -> this.findRelatedVerbs());
        return jButton;
    }

    private void findRelatedVerbs() {
        this.verbsAndAdjectivesFinder.findRelatedVerbs(this.vocable);
    }

    public Component createFindRelatedAdjectiveButton() {
        JButton jButton = new JButton("Liste von zugeh\u00f6rigen Adjektivformen anzeigen.");
        jButton.addActionListener(actionEvent -> this.findRelatedAdjectives());
        return jButton;
    }

    private void findRelatedAdjectives() {
        this.verbsAndAdjectivesFinder.findRelatedAdjectives(this.vocable);
    }

    public Component createFindRelatedVerbsButtonViaWoerterbuchform(Vocable vocable) {
        JButton jButton = new JButton("Liste von zugeh\u00f6rigen Verbformen zur W\u00f6rterbuchform anzeigen.");
        jButton.addActionListener(actionEvent -> this.verbsAndAdjectivesFinder.findRelatedVerbs(vocable));
        return jButton;
    }

    public Component createFindRelatedAdjectiveButtonViaPositivePresence(Vocable vocable) {
        JButton jButton = new JButton("Liste von zugeh\u00f6rigen Adjektivformen zur Grundform anzeigen.");
        jButton.addActionListener(actionEvent -> this.verbsAndAdjectivesFinder.findRelatedAdjectives(vocable));
        return jButton;
    }
}

