/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet;

import de.duehl.basics.system.SystemTools;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.tools.VocableListShuffler;
import de.duehl.vocabulary.japanese.ui.components.VocableViewer;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.VocableWithInternaViewer;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet.data.WithVocablePanesStartable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VocableSheetsCreator {
    private final List<Vocable> vocables;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final WithVocablePanesStartable startable;
    private final Point parentLocation;
    private List<Component> vocablePanes;
    private List<Runnable> runnables;

    public VocableSheetsCreator(List<Vocable> list, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, WithVocablePanesStartable withVocablePanesStartable, Point point) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.startable = withVocablePanesStartable;
        this.parentLocation = point;
        Options options = fumikoDataStructures.getOptions();
        if (options.isUseVocablesShuffleTypeForShowingListsAndSheetsToo()) {
            VocablesShuffleType vocablesShuffleType = options.getVocablesShuffleType();
            VocableListShuffler vocableListShuffler = new VocableListShuffler(list, vocablesShuffleType, fumikoDataStructures);
            vocableListShuffler.shuffle();
            this.vocables = vocableListShuffler.getVocables();
        } else {
            this.vocables = list;
        }
    }

    public void create() {
        this.init();
        this.createRunnables();
        this.createVocablePanesInEdtLoop();
    }

    private void init() {
        this.vocablePanes = new ArrayList<Component>();
    }

    private void createRunnables() {
        this.runnables = new ArrayList<Runnable>();
        for (Vocable vocable : this.vocables) {
            this.runnables.add(() -> this.createAndAddVocablePane(vocable));
        }
        this.runnables.add(() -> this.startable.runWithVocablePanes(this.vocables, this.vocablePanes));
    }

    private void createAndAddVocablePane(Vocable vocable) {
        Component component = this.createVocablePane(vocable);
        this.vocablePanes.add(component);
    }

    private Component createVocablePane(Vocable vocable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPureVocablePane(vocable), "Center");
        Options options = this.dataStructures.getOptions();
        if (options.isShowDetailsButtonInVokabelblattDarstellung()) {
            jPanel.add(this.createDetailsButton(vocable), "South");
        }
        return jPanel;
    }

    private Component createPureVocablePane(Vocable vocable) {
        Options options = this.dataStructures.getOptions();
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        VocableViewer vocableViewer = new VocableViewer(options);
        vocableViewer.showVocable(vocable, internalDataRequester.getInternalDataForVocable(vocable));
        return vocableViewer.getPanel();
    }

    private Component createDetailsButton(Vocable vocable) {
        JButton jButton = new JButton("Details anzeigen");
        jButton.addActionListener(actionEvent -> this.showDetails(vocable));
        return jButton;
    }

    private void showDetails(Vocable vocable) {
        VocableWithInternaViewer vocableWithInternaViewer = new VocableWithInternaViewer(vocable, this.dataStructures, this.uiObjects, this.parentLocation);
        vocableWithInternaViewer.setVisible(true);
    }

    private void createVocablePanesInEdtLoop() {
        for (Runnable runnable : this.runnables) {
            SwingUtilities.invokeLater(runnable);
            SystemTools.sleep(5L);
        }
    }
}

