package de.duehl.basics.caller;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt eine hübschere Variante vom StackTraceElement dar.
 *
 * @version 1.01     2020-01-28
 * @author Christian Dühl
 */

public class NiceStackTraceElement {

    private final StackTraceElement element;

    public NiceStackTraceElement(StackTraceElement element) {
        this.element = element;
    }

    public String getClassName() {
        return element.getClassName();
    }

    public Class<?> getClassObject() {
        try {
            return Class.forName(getClassName());
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFileName() {
        return element.getFileName();
    }

    public int getLineNumber() {
        return element.getLineNumber();
    }

    public String getMethodName() {
        return element.getMethodName();
    }

    public String getModuleName() {
        return element.getModuleName();
    }

    public String getModuleVersion() {
        return element.getModuleVersion();
    }

    @Override
    public String toString() {
        return getClassName()
                + "#" + getMethodName()
                + "() - " + getLineNumber()
                ;
    }

    public String toStringWithAll() {
        return "Klasse: " + getClassName()
                + ", Methode: " + getMethodName()
                + ", Zeile: " + getLineNumber()
                + ", Datei: " + getFileName()
                + ", Modul: " + getModuleName()
                + ", Modul-Version: " + getModuleVersion()
                + ", Datei: " + getFileName()
                ;
    }

}
