package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.regex.Pattern;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse stellt die Methode zum Parsen eines Datums bestehend aus 8 Ziffern (vierstelliges
 * Jahr, zweistelliger Monat, zweistelliger Tag) aus einem String dar.
 *
 * Erkannt werden:
 *     - 20130822
 *
 * @version 1.01     2018-11-16
 * @author Christian Dühl
 */

public class DateParseMethodYYYYMMDD extends DateParseMethod {

    private final static Pattern PATTERN = Pattern.compile(
            "(\\d{4})(\\d{2})(\\d{2})");

    public DateParseMethodYYYYMMDD(String dateToParse) {
        super(dateToParse, PATTERN);
    }

    @Override
    protected ImmutualDate createDateFromMatcher() {
        int day   = Integer.parseInt(matcher.group(3));
        int month = Integer.parseInt(matcher.group(2));
        int year  = Integer.parseInt(matcher.group(1));

        return new ImmutualDate(day, month, year);
    }

}
