package de.duehl.basics.io;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.Objects;

/**
 * Diese Klasse liest eine Datei, die neben einer Klasse in einem Jar liegt.
 *
 * @version 1.05     2019-03-07
 * @author Christian Dühl
 */

public class FileFromJarReader extends FineFileReader {

    /**
     * Konstruktor.
     *
     * @param clazz
     *            Klasse, in deren Verzeichnis die Textdatei liegt.
     * @param filename
     *            Name der Datei ohne Pfad.
     * @param charset
     *            Kodierung der textdatei.
     */
    public FileFromJarReader(Class<?> clazz, String filename, Charset charset) {
        super(filename, charset, openReader(clazz, filename, charset));
    }

    private static LineNumberReader openReader(Class<?> clazz, String filename, Charset charset) {
        try {
            return tryToOpenReader(clazz, filename, charset);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static LineNumberReader tryToOpenReader(Class<?> clazz, String filename,
            Charset charset) throws UnsupportedEncodingException {
        InputStream is = Objects.requireNonNull(clazz.getResourceAsStream(filename),
                "Die Datei '" + filename + "' gibt es nicht!");
        InputStreamReader isr = new InputStreamReader(is, charset.getCharsetAsString());
        LineNumberReader reader = new LineNumberReader(isr);
        return reader;
    }

}
