package de.duehl.basics.io;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.io.exceptions.IORuntimeException;
import de.duehl.basics.text.Lines;

public interface Writer {

    /**
     * Schreibt den übergebenen String auf den Writer.
     *
     * @param text
     *            Der auszugebende Text.
     * @throws IORuntimeException
     *             Falls beim Schreiben ein Fehler auftrat.
     */
    void write(String text);

    /**
     * Schreibt die übergebene Zahl auf den Writer.
     *
     * @param number
     *            Die auszugebende Zahl.
     * @throws IORuntimeException
     *             Falls beim Schreiben ein Fehler auftrat.
     */
    void write(int number);

    /** Gibt einen Zeilenumbruch aus. */
    void writeln();

    /**
     * Schreibt den übergebenen String auf den Writer und fügt einen
     * Zeilenumbruch an.
     *
     * @param text
     *            Der auszugebende Text.
     * @throws IORuntimeException
     *             Falls beim Schreiben ein Fehler auftrat.
     */
    void writeln(String text);

    /**
     * Schließt den Writer.
     *
     * @throws IORuntimeException
     *             Falls beim Schließen ein Fehler auftrat.
     */
    void close();

    /**
     * Veranlasst den Writer alle Daten im Zwischenspeicher in die Datei zu
     * schreiben.
     *
     * @throws IORuntimeException
     *             Falls beim flush ein Fehler auftrat.
     */
    void flush();

    /**
     * Schreibt alle Zeilen der übergebenen Liste auf den Writer und fügt
     * jeweils einen Zeilenumbruch an.
     *
     * @param list
     *            Die Liste mit den auszugebenden Zeilen.
     * @throws IORuntimeException
     *             Falls beim Schreiben ein Fehler auftrat.
     */
    void writeAllLines(List<String> list);

    /**
     * Schreibt alle Zeilen der übergebenen Liste auf den Writer und fügt
     * jeweils einen Zeilenumbruch an.
     *
     * @param list
     *            Die Liste mit den auszugebenden Zeilen.
     * @throws IORuntimeException
     *             Falls beim Schreiben ein Fehler auftrat.
     */
    void writeAllLines(Lines lines);

    /**
     * Schreibt eine Menge von Strings tabgetrennt in eine Zeile und fügt einen
     * Zeilenumbruch an.
     *
     * @param fields
     *            Menge der tabgetrennt auszugebenden Strings.
     */
    void writeFieldsLine(List<String> fields);

    /**
     * Schreibt eine Menge von Strings tabgetrennt in eine Zeile und fügt einen
     * Zeilenumbruch an.
     *
     * @param fields
     *            Menge der tabgetrennt auszugebenden Strings.
     */
    void writeFieldsLine(String ... fields);

    /**
     * Schreibt eine Menge von Strings tabgetrennt in eine Zeile und fügt einen
     * Zeilenumbruch an.
     *
     * @param fields
     *            Menge der tabgetrennt auszugebenden Strings.
     * @param moreFields
     *            Weitere Menge von tabgetrennt auszugebenden Strings.
     */
    void writeFieldsLine(List<String> fields, String ... moreFields);

    /** Getter für den Namen der Ausgabedatei. */
    String getFileName();

}
