package de.duehl.basics.io.exceptions;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Ausnahmeklasse, die geworfen wird, wenn ein Verzeichnis nicht angelegt werden kann.
 *
 * @version 1.01     2013-12-12
 * @author Christian Dühl
 */

public class DirectoryNotCreatedRuntimeException extends RuntimeException {

    private static final long serialVersionUID = -6328125243878508895L;

    /** Konstruktor */
    public DirectoryNotCreatedRuntimeException() {
        super();
    }

    /**
     * Konstruktor
     *
     * @param message
     *            Text der Fehlermeldung.
     */
    public DirectoryNotCreatedRuntimeException(String message) {
        super(message);
    }

}