package de.duehl.basics.io.lock;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface dient zur Abstraktion von konkreten Locks mit Dateinamen.
 *
 * @version 1.01     2021-02-09
 * @author Christian Dühl
 */

public abstract class LockBase implements Lock {

    /** Die Datei, die gelockt wird oder die zum Lock benutzt wird. */
    protected String filename;

    /**
     * Konstruktor.
     *
     * @param filename
     *            Die Datei, die gelockt wird oder die zum Lock benutzt wird.
     */
    public LockBase(String filename) {
        this.filename = filename;
    }

    /**
     * Versucht einen Lock auf die Datei zu erhalten.
     *
     * @return Erfolg
     */
    @Override
    public abstract boolean lock();

    /**
     * Versucht den vorhandenen Lock wieder zu lösen.
     *
     * @return Erfolg.
     */
    @Override
    public abstract boolean unlock();

    /** Getter für die Datei, die gelockt wird oder die zum Lock benutzt wird. */
    @Override
    public String getFilename() {
        return filename;
    }

}
