package de.duehl.basics.io.textfile;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.Charset;

/**
 * Diese Klasse liest eine Liste mit den Texten im Format von Zuweisungen mit Gleichheitszeichen
 * oder Doppelpunkt aus den Zeilen einer normalen Textdatei ein.
 *
 * Das Format sieht wie folgt aus:
 *
 *     Schlüssel : Wert
 *
 * oder
 *
 *     Schlüssel = Wert
 *
 * Kommt in einer Datenzeile weiter hinten das Kommentarzeichen vor, so wird ab dort abgeschnitten
 * und getrimmt.
 *
 * @version 1.01     2021-03-01
 * @author Christian Dühl
 */

public class DefinitionsFromNormalTextFileReader extends DefinitionsFromTextFileReader {

    /** Kommentarzeichen '#' für Konstruktoren ohne diese Angabe. */
    private static final String DEFAULT_COMMENT_CHARACTER = "#";

    /**
     * Konstruktor für UTF-8 Files mit Standard-Kommentarzeichen '#'.
     *
     * @param filename
     *            Name der einzulesenden Datei.
     */
    public DefinitionsFromNormalTextFileReader(String filename) {
        this(filename, Charset.UTF_8, DEFAULT_COMMENT_CHARACTER);
    }

    /**
     * Konstruktor für UTF-8 Files.
     *
     * @param filename
     *            Name der einzulesenden Datei.
     * @param charset
     *            Kodierung der einzulesenden Datei.
     */
    public DefinitionsFromNormalTextFileReader(String filename, Charset charset) {
        this(filename, charset, DEFAULT_COMMENT_CHARACTER);
    }

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der einzulesenden Datei.
     * @param charset
     *            Kodierung der einzulesenden Datei.
     * @param commentChar
     *            Das Kommentarzeichen.
     */
    public DefinitionsFromNormalTextFileReader(String filename, Charset charset,
            String commentChar) {
        super(new StringsFromNormalTextFileReader(filename, charset, commentChar));
    }

}
