package de.duehl.basics.io.textfile.data;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

/**
 * Dieses Interface steht für eine Datenklasse die man mit Überschriften und einer Zeile pro Objekt
 * in einer Datei speichern kann.
 *
 * @version 1.01     2022-07-22
 * @author Christian Dühl
 */

public interface DataWithTitlesAndValues {

    /** Gibt die Felder für die Titelzeile für die Datei zurück. */
    List<String> titles();

    /** Gibt die Felder für eine Zeile mit dem Datensatz für die Datei zurück. */
    List<String> values();

}
