package de.duehl.basics.io.zip.data;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;

/**
 * Diese Klasse enthält den Namen eines Archivs und der zu verpackenden Dateien.
 *
 * @version 1.01     2022-04-06
 * @author Christian Dühl
 */

public class ZipArchive {

    /** Der Name des Ziparchivs im Dateisystem mit Pfad. */
    private final String archiveFilename;

    /** Die Namen der zu packenden Dateien im Dateisystem mit Pfad. */
    private final List<String> filesToZip;

    /**
     * Konstruktor für ein Archiv mit einer Datei.
     *
     * @param archiveFilename
     *            Der Name des Ziparchivs im Dateisystem mit Pfad.
     * @param fileToZip
     *            Der Name der zu packenden Datei im Dateisystem mit Pfad.
     */
    public ZipArchive(String archiveFilename, String fileToZip) {
        this(archiveFilename, CollectionsHelper.buildListFrom(fileToZip));
    }

    /**
     * Konstruktor für ein Archiv mit mehreren Dateien.
     *
     * @param archiveFilename
     *            Der Name des Ziparchivs im Dateisystem mit Pfad.
     * @param filesToZip
     *            Die Namen der zu packenden Dateien im Dateisystem mit Pfad.
     */
    public ZipArchive(String archiveFilename, List<String> filesToZip) {
        this.archiveFilename = archiveFilename;
        this.filesToZip = filesToZip;
    }

    /** Getter für den Namen des Ziparchivs im Dateisystem mit Pfad. */
    public String getArchiveFilename() {
        return archiveFilename;
    }

    /** Getter für die Namen der zu packenden Dateien im Dateisystem mit Pfad. */
    public List<String> getFilesToZip() {
        return filesToZip;
    }

    @Override
    public String toString() {
        return "ZipArchive [archiveFilename=" + archiveFilename + ", filesToZip=" + filesToZip
                + "]";
    }

}
