package de.duehl.basics.logging;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Klasse stellt die abstrakte Basis für wirkliche Logger dar. Sie hält die Nummer der
 * zuletzt geschriebenen oder gemerkten Zeile fest, da dies für Fehlermeldungen gebraucht wird, die
 * diese Information weitergeben.
 *
 * @version 1.01     2017-03-31
 * @author Christian Dühl
 */

abstract class NumberOfLinesLogger implements Logger {

    /** Zähler für die Anzahl der Zeilen im Logfile. */
    private int numberOfLinesInLogfile;

    /** Konstruktor. */
    public NumberOfLinesLogger() {
        numberOfLinesInLogfile = 0;
    }

    /** Erhöht die Anzahl der Zeilen im Logfile um eins. */
    protected final void incrementNumberOfLinesInLogfile() {
        ++numberOfLinesInLogfile;
    }

    /**
     * Gibt die zuletzt geschriebene Zeilennummer (oder anders gesagt die Anzahl an Zeilen im
     * Logger) zurück.
     *
     * @return Zeilennummer der zuletzt geschriebenen Zeile.
     */
    @Override
    public int getLastWrittenLineNumber() {
        return numberOfLinesInLogfile;
    }

}
