package de.duehl.basics.retry;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, das man mehrfach versuchen lassen kann, etwas
 * auszuführen.
 *
 * @version 1.01     2017-05-05
 * @author Christian Dühl
 */

public interface Retryable {

    /**
     * Versucht die Aufgabe auszuführen. Wenn die Methode normal durchläuft, wird dies als Erfolg
     * gewertet.
     *
     * Misserfolg wird durch das Werfen einer Ausnahme angezeigt.
     * Darum muss sich die Klasse kümmern, die das Interface implementiert!
     */
    void tryIt();

}
