package de.duehl.basics.system;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Diese Klasse kann danach gefragt werden, wo gerade das Programm ausgeführt
 * wird.
 *
 * @version 1.01     2014-02-14
 * @author Christian Dühl
 */

public class WhereAreWeOld {

    /** Die verschiedenen Orte. */
    private enum Place {
        AT_WORK, AT_HOME, NOWHERE
    }

    /** Privater Konstruktor. */
    private WhereAreWeOld() {}

    /** Gibt an, ob das Programm bei der Arbeit ausgeführt wird. */
    public static boolean areWeAtWork() {
        return whereAreWe() == Place.AT_WORK;
    }

    /** Gibt an, ob das Programm zu Hause ausgeführt wird. */
    public static boolean areWeAtHome() {
        return whereAreWe() == Place.AT_HOME;
    }

    /** Ermittelt anhand der lokalen IP-Adresse, wo wir sein könnten. */
    private static Place whereAreWe() {
        InetAddress address = getIpAddress();
        if (null == address) {
            return Place.NOWHERE;
        }
        //String hostName = address.getHostName();
        String hostAddress = address.getHostAddress();
        if (hostAddress.startsWith("192.168.30.")) {
            return Place.AT_WORK;
        }
        return Place.AT_HOME;
    }

    /** Ermittelt die IP-Adresse. */
    private static InetAddress getIpAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

}
