package de.duehl.basics.system.starter;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.logging.Logger;
import de.duehl.basics.logic.ErrorHandler;

/**
 * Diese Klasse ist die abstrakte Basis für Klassen, die externe Prozesse aufrufen (wie SasStarter
 * oder CmdStarter).
 *
 * @version 1.01     2021-05-27
 * @author Christian Dühl
 */

public abstract class Starter {

    /** Der Logger für den Ablauf dieser Session. */
    private final Logger logger;

    /** Objekt, das die Fehlerbehandlung durchführt. */
    protected final ErrorHandler error;

    /**
     * Konstruktor.
     *
     * @param logger
     *            Der Logger für den Ablauf dieser Session.
     * @param error
     *            Objekt, das die Fehlerbehandlung durchführt.
     */
    public Starter(Logger logger, ErrorHandler error) {
        this.logger = logger;
        this.error = error;
    }

    /**
     * Erstellt einen String aus den einzelnen Teilen der Aufrufparameter.
     *
     * @param params
     *            Aufrufparameter
     * @return in einem String zusammengesetzte Parameter.
     */
    protected String paramsToString(String[] params) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(params[i]);
        }

        return builder.toString();
    }

    /** Gibt eine Nachricht über den Logger aus. */
    protected void log(String message) {
        if (logger != null) {
            logger.log(message, 1);
        }
    }

}
