package de.duehl.basics.text.data;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt eine der verschiedenen Klassen (männlich, weiblich, sächlich), in die die
 * Substantive (danach Adjektive und Pronomen) eingeteilt sind; grammatikalische Kategorie beim
 * Nomen; grammatisches Geschlecht dar.
 *
 * @version 1.01     2022-07-15
 * @author Christian Dühl
 */

public enum WordGenus {

    MALE("der", "ein", "er", "er"),
    FEMALE("die", "eine", "sie", "e"),
    NEUTER("das", "ein", "es", "");

    /** Der bestimmte Artikel ("der" / "die" / "das"). */
    private final String bestimmterArtikel;

    /** Der unbestimmte Artikel ("ein" / "eine" / "ein"). */
    private final String unbestimmterArtikel;

    /** Das Personalpronomen ("er" / "sie" / "es"). */
    private final String personalPronomen;

    /** Zeichen hinter einem Adjektiv ("schön" + "er" / "e" / "es"). */
    private final String restNachAdjektiven;

    /**
     * Konstruktor.
     *
     * @param bestimmterArtikel
     *            Der bestimmte Artikel ("der" / "die" / "das").
     * @param unbestimmterArtikel
     *            Der unbestimmte Artikel ("ein" / "eine" / "ein").
     * @param personalPronomen
     *            Das Personalpronomen ("er" / "sie" / "es").
     * @param restNachAdjektiven
     *            Zeichen hinter einem Adjektiv ("schön" + "er" / "e" / "es").
     */
    private WordGenus(String bestimmterArtikel, String unbestimmterArtikel, String personalPronomen,
            String restNachAdjektiven) {
        this.bestimmterArtikel = bestimmterArtikel;
        this.unbestimmterArtikel = unbestimmterArtikel;
        this.personalPronomen = personalPronomen;
        this.restNachAdjektiven = restNachAdjektiven;
    }

    /** Getter für den bestimmten Artikel ("der" / "die" / "das"). */
    public String getBestimmterArtikel() {
        return bestimmterArtikel;
    }

    /** Getter für den unbestimmten Artikel ("ein" / "eine" / "ein"). */
    public String getUnbestimmterArtikel() {
        return unbestimmterArtikel;
    }

    /** Getter für das Personalpronomen ("er" / "sie" / "es"). */
    public String getPersonalPronomen() {
        return personalPronomen;
    }

    /** Getter für die Zeichen hinter einem Adjektiv ("schön" + "er" / "e" / "es"). */
    public String getRestNachAdjektiven() {
        return restNachAdjektiven;
    }

}
