package de.duehl.basics.text.definitions;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.text.Text;

/**
 * Diese Klasse parst eine Zeile mit einer Definition aus einer Datei Objekten, die in Blöcken mit
 * Definitionszeilen der Art
 *     Key = Value
 * definiert werden, wie z.B. Vokabeln oder spezielle Personen.
 *
 * @version 1.01     2023-12-01
 * @author Christian Dühl
 */

public class DefinitionLineParser {

    /** Der Name der Datei mit den Vokabeln mit Pfad für Fehlermeldungen. */
    private final String filename;

    /** Die zu parsende Zeile mit einer Definition aus der Datei. */
    private final String line;

    /** Der Schlüssel der Definition. */
    private String key;

    /** Der Wert der Definition. */
    private String value;

    /**
     * Konstruktor.
     *
     * @param line
     *            Die zu parsende Zeile mit einer Definition aus der Datei.
     * @param filename
     *            Der Name der Datei mit den Vokabeln mit Pfad für Fehlermeldungen.
     */
    public DefinitionLineParser(String line, String filename) {
        this.line = line;
        this.filename = filename;
    }

    /** Parst die Zeile. */
    public void parse() {
        int firstEqualIndex = line.indexOf("=");
        if (firstEqualIndex == -1) {
            throw new RuntimeException(""
                    + "Eine nicht-leere Zeile, die kein Kommentar ist, enthält kein "
                    + "Gleichheitszeichen.\n"
                    + "\t" + "filename = '" + filename + "'.\n"
                    + "\t" + "Zeile    = '" + line + "'.\n");
        }

        key = line.substring(0, firstEqualIndex).strip();
        value = line.substring(firstEqualIndex + 1).strip();
        key = Text.toLowerCase(key);
    }

    /** Getter für den Schlüssel der Definition. */
    public String getKey() {
        return key;
    }

    /** Getter für den Wert der Definition. */
    public String getValue() {
        return value;
    }

}
