package de.duehl.basics.text.sort.tools;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.text.Text;

/**
 * Diese Klasse stellt ein Element zum Sortieren deutscher Worte dar.
 *
 * @version 1.01     2019-07-12
 * @author Christian Dühl
 */

public class SortableElement {

    private final String originalWord;

    private final String compareWord;

    public SortableElement(String originalWord) {
        this.originalWord = originalWord;
        compareWord = createCompareWord();
    }

    private String createCompareWord() {
        String compare = originalWord;

        compare = Text.toLowerCase(compare);
        compare = compare.replace("ä", "ae");
        compare = compare.replace("ö", "oe");
        compare = compare.replace("ü", "ue");
        compare = compare.replace("ß", "ss");

        return compare;
    }

    public String getOriginalWord() {
        return originalWord;
    }

    public String getCompareWord() {
        return compareWord;
    }

    @Override
    public String toString() {
        return "SortableElement [originalWord=" + originalWord + ", compareWord=" + compareWord
                + "]";
    }

}
