package de.duehl.basics.autodetect;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class AutoDetectionHelperTest {

    @Test
    public void createEntityString() {
        String replacementFrontPart = "street";
        String replacementNumber = "7";
        String actual = AutoDetectionHelper.createEntity(replacementFrontPart, replacementNumber);
        String expected = "<<street:7>>";
        assertEquals(expected, actual);
    }

    @Test
    public void createEntity() {
        String replacementFrontPart = "street";
        int replacementNumber = 7;
        String actual = AutoDetectionHelper.createEntity(replacementFrontPart, replacementNumber);
        String expected = "<<street:7>>";
        assertEquals(expected, actual);
    }

}
