package de.duehl.basics.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.system.starter.CmdStarter;
import de.duehl.basics.logging.FileLogger;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.logic.PrintErrorHandler;

public class CmdStarterTest {

    public CmdStarterTest() {
        int variante = 2;
        switch (variante) {
            case 1:
                test1();
                break;
            case 2:
                test2();
                break;
        }
    }

    private void test1() {
        String prg = "c:/temp/blubb.cmd";
        String log = "c:/temp/blubb.log";
        String err = "c:/temp/blubb.err";
        String logPath = "c:/temp/";
        Logger logger = FileLogger.create("CmdStarterTest", ".log", logPath);
        PrintErrorHandler error = new PrintErrorHandler();
        CmdStarter starter = new CmdStarter(logger, error);
        starter.runAndWait(prg, log, err);
    }

    private void test2() {
        String prg = "c:/temp/blubb.cmd";
        String log = "c:/temp/blubb.log";
        String err = "c:/temp/blubb.err";
        String logPath = "c:/temp/";
        Logger logger = FileLogger.create("CmdStarterTest", ".log", logPath);
        PrintErrorHandler error = new PrintErrorHandler();
        CmdStarter starter = new CmdStarter(logger, error);
        Process process = starter.startRun(prg);
        starter.waitForProcessAndWriteStreams(process, log, err);
    }

    public static void main(String[] args) {
        new CmdStarterTest();
    }

}



/* c:\temp\blubb.cmd:

dir

*/
