package de.duehl.basics.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logging.eraser.LogEraser;

public class RemoveTestLogfilesOfDetailedFileLoggerTest {

    public static void main(String[] args) {
        String front = "LoggerTest_";
        String rear = ".tmp";
        String path = "C:\\Users\\Anwender\\AppData\\Local\\Temp\\";

        System.out.println("VORHER:");
        printLogFileNames(front, rear, path);

        LogEraser eraser = new LogEraser(path, front, rear);
        eraser.erase();

        System.out.println("NACHHER:");
        printLogFileNames(front, rear, path);
    }

    private static void printLogFileNames(String front, String rear, String path) {
        for (String file : FileHelper.findAllNormalFilesInMainDirectory(path)) {
            String bare = FileHelper.getBareName(file);
            if (bare.startsWith(front) && bare.endsWith(rear)) {
                System.out.println("    " + bare);
            }
        }
    }

}
