package de.duehl.basics.test;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import org.junit.After;
import org.junit.Before;

import de.duehl.basics.system.OutputStreamSaveAndRelease;

/**
 * Diese Klasse stellt eine Basisklasse für Unit-Tests dar, die mit Ausgaben auf System.out oder
 * System.err fangen oder schlicht nicht anzeigen wollen.
 *
 * @version 1.01     2016-01-21
 * @author Christian Dühl
 */

public abstract class OutAndErrStreamHandlingTest {

    private final OutputStreamSaveAndRelease streamSave = new OutputStreamSaveAndRelease();

    /** Sichert den originalen Strom System.out und lenkt System.out auf einen neuen um. */
    protected void saveSystemOut() {
        streamSave.saveSystemOut();
    }

    /** Setzt System.out wieder auf den Standard. */
    protected void releaseSystemOut() {
        streamSave.releaseSystemOut();
    }

    /** Sichert den originalen Strom System.err und lenkt System.err auf einen neuen um. */
    protected void saveSystemErr() {
        streamSave.saveSystemErr();
    }

    /** Setzt System.err wieder auf den Standard. */
    protected void releaseSystemErr() {
        streamSave.releaseSystemErr();
    }

    /** Liefert den während dem Test nach System.out geschriebenen Text. */
    protected String getOutContents() {
        return streamSave.getOutContents();
    }

    /** Liefert den während dem Test nach System.err geschriebenen Text. */
    protected String getErrContents() {
        return streamSave.getErrContents();
    }

    /** Sichert die Ströme System.out und System.err vor jedem Test. */
    @Before
    public void before() {
        saveSystemOut();
        saveSystemErr();
    }

    /** Stellt nach jedem Test die originalen Ströme System.out und System.err wieder her. */
    @After
    public void after() {
        releaseSystemOut();
        releaseSystemErr();
    }

    /** Gibt eine Nachricht auf dem originalen System.out aus, wenn dies gesichert ist. */
    protected void printOut(String message) {
        streamSave.printOut(message);
    }

}
