package de.duehl.basics.test;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class OutAndErrStreamHandlingTestTest extends OutAndErrStreamHandlingTest {

    @Test
    public void printSomethingAndCatchOut() {
        String message = "Hallo Welt!";
        System.out.print(message);
        String actual = getOutContents();
        String expected = message;
        assertEquals(expected, actual);
    }

    @Test
    public void printSomethingAndCatchErr() {
        String message = "Hallo Welt!";
        System.err.print(message);
        String actual = getErrContents();
        String expected = message;
        assertEquals(expected, actual);
    }

    @Test
    public void printSomething() {
        System.out.println("Huhu");
    }

}
