package de.duehl.basics.text;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

public class SentenceSplitterTest {

    @Test
    public void split1() {
        String input = "Wie teilt man das hier (), auf?";
        List<String> output = SentenceSplitter.splitWords(input);

//        for (int i = 0; i < output.size(); ++i) {
//            System.out.println("    wort " + i + ": [" + output.get(i) + "]");
//        }

        assertEquals(15, output.size());
        assertEquals("Wie", output.get(0));
        assertEquals("das", output.get(6));
        assertEquals("()", output.get(10));
        assertEquals(",", output.get(11));
        assertEquals("?", output.get(14));
    }

    @Test
    public void split2() {
        String input = "Allgemeiner Handel ( ), Handel mit Baumaterialien.";
        List<String> output = SentenceSplitter.splitWords(input);

//        for (int i = 0; i < output.size(); ++i) {
//            System.out.println("    wort " + i + ": [" + output.get(i) + "]");
//        }

        assertEquals(15, output.size());
        assertEquals("Allgemeiner", output.get(0));
        assertEquals("Handel", output.get(2));
        assertEquals("Handel", output.get(9));
        assertEquals(".", output.get(14));
    }

    @Test
    public void splitEmptyString() {
        String input = "";
        List<String> output = SentenceSplitter.splitWords(input);

//        for (int i = 0; i < output.size(); ++i) {
//            System.out.println("    wort " + i + ": [" + output.get(i) + "]");
//        }

        assertEquals(1, output.size());
        assertEquals("", output.get(0));
    }

    @Test
    public void splitSpace() {
        String input = " ";
        List<String> output = SentenceSplitter.splitWords(input);

//        for (int i = 0; i < output.size(); ++i) {
//            System.out.println("    wort " + i + ": [" + output.get(i) + "]");
//        }

        assertEquals(1, output.size());
        assertEquals(" ", output.get(0));
    }

}
