package de.duehl.basics.text.handling;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class BooleanHandlingTest {

    @Test
    public void booleanFalseToString() {
        boolean input = false;
        String actual = BooleanHandling.booleanToString(input);
        String expected = "nein";
        assertEquals(expected, actual);
    }

    @Test
    public void booleanTrueToString() {
        boolean input = true;
        String actual = BooleanHandling.booleanToString(input);
        String expected = "ja";
        assertEquals(expected, actual);
    }

    @Test
    public void booleanFalseToTrueFalseString() {
        boolean input = false;
        String actual = BooleanHandling.booleanToTrueFalseString(input);
        String expected = "false";
        assertEquals(expected, actual);
    }

    @Test
    public void booleanTrueToTrueFalseString() {
        boolean input = true;
        String actual = BooleanHandling.booleanToTrueFalseString(input);
        String expected = "true";
        assertEquals(expected, actual);
    }

    @Test
    public void booleanFalseToWahrFalschString() {
        boolean input = false;
        String actual = BooleanHandling.booleanToWahrFalschString(input);
        String expected = "falsch";
        assertEquals(expected, actual);
    }

    @Test
    public void booleanTrueToWahrFalschString() {
        boolean input = true;
        String actual = BooleanHandling.booleanToWahrFalschString(input);
        String expected = "wahr";
        assertEquals(expected, actual);
    }

    @Test
    public void stringJaToBoolean() {
        String input = "ja";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = true;
        assertEquals(expected, actual);
    }

    @Test
    public void stringJaBigToBoolean() {
        String input = "JA";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = true;
        assertEquals(expected, actual);
    }

    @Test
    public void stringJaMixedToBoolean() {
        String input = "Ja";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = true;
        assertEquals(expected, actual);
    }

    @Test
    public void stringNeinToBoolean() {
        String input = "nein";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = false;
        assertEquals(expected, actual);
    }

    @Test
    public void stringNeinBigToBoolean() {
        String input = "NEIN";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = false;
        assertEquals(expected, actual);
    }

    @Test
    public void stringNeinMixedToBoolean() {
        String input = "NeIn";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = false;
        assertEquals(expected, actual);
    }

    @Test
    public void stringTrueToBoolean() {
        String input = "true";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = true;
        assertEquals(expected, actual);
    }

    @Test
    public void stringTrueBigToBoolean() {
        String input = "TRUE";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = true;
        assertEquals(expected, actual);
    }

    @Test
    public void stringTrueMixedToBoolean() {
        String input = "trUe";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = true;
        assertEquals(expected, actual);
    }

    @Test
    public void stringFalseToBoolean() {
        String input = "false";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = false;
        assertEquals(expected, actual);
    }

    @Test
    public void stringFalseBigToBoolean() {
        String input = "FALSE";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = false;
        assertEquals(expected, actual);
    }

    @Test
    public void stringFalseMixedToBoolean() {
        String input = "falSe";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = false;
        assertEquals(expected, actual);
    }

    @Test (expected = IllegalArgumentException.class)
    public void stringWrongToBoolean() {
        String input = "unsinn";
        BooleanHandling.stringToBoolean(input);
    }

    @Test
    public void stringWahrToBoolean() {
        String input = "wahr";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = true;
        assertEquals(expected, actual);
    }

    @Test
    public void stringFalschToBoolean() {
        String input = "falsch";
        boolean actual = BooleanHandling.stringToBoolean(input);
        boolean expected = false;
        assertEquals(expected, actual);
    }

}
