package de.duehl.basics.text.sort;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import de.duehl.basics.collections.CollectionsHelper;

public class WordsSorterTest {

    @Test
    public void sortSmallAndBigTogether() {
        List<String> words = CollectionsHelper.buildListFrom("Bauen", "bauen", "angeben", "Angeben");

        WordsSorter sorter = new WordsSorter(words);
        sorter.sort();

        assertEquals(4, words.size());
        assertEquals("Angeben", words.get(0));
        assertEquals("angeben", words.get(1));
        assertEquals("Bauen", words.get(2));
        assertEquals("bauen", words.get(3));
    }

    @Test
    public void sortUmlautsCorrect() {
        List<String> words = CollectionsHelper.buildListFrom("aufbäumen", "aufbauen", "aufbbbb",
                "aufbaaa");

        WordsSorter sorter = new WordsSorter(words);
        sorter.sort();

        assertEquals(4, words.size());
        assertEquals("aufbaaa", words.get(0));
        assertEquals("aufbäumen", words.get(1));
        assertEquals("aufbauen", words.get(2));
        assertEquals("aufbbbb", words.get(3));
    }

}
