package de.duehl.html.download.proxy;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.net.InetAddress;
import java.net.UnknownHostException;

import de.duehl.html.download.exceptions.UnknownHostRuntimeException;

/**
 * Diese Klasse stellt einen Proxy dar.
 *
 * @version 1.01     2017-04-27
 * @author Christian Dühl
 */

public class Proxy {

    /** Adresse des Proxys. */
    private final InetAddress address;

    /** Port des Proxys. */
    private final int port;

    /**
     * Konstruktor.
     *
     * @param address
     *            Adresse des Proxys.
     * @param port
     *            Port des Proxys.
     */
    public Proxy(String address, int port) {
        try {
            this.address = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new UnknownHostRuntimeException(e);
        }
        this.port = port;
    }

    /**
     * Konstruktor.
     *
     * @param address
     *            Adresse des Proxys.
     * @param port
     *            Port des Proxys.
     */
    public Proxy(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    /** Getter für die Adresse des Proxys. */
    public InetAddress getAddress() {
        return address;
    }

    /** Getter für den Port des Proxys. */
    public int getPort() {
        return port;
    }

    @Override
    public String toString() {
        return "Proxy [address=" + address + ", port=" + port + "]";
    }

}
