package de.duehl.swing.data;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Enum-Klasse stellt Auswahl täglich, wöchentlich oder gar nicht dar.
 *
 * @version 1.01     2017-03-17
 * @author Christian Dühl
 */

public enum DailyWeeklyNotType {
    DAILY, WEEKLY, NOT;

    public static DailyWeeklyNotType determineByName(String typeName) {
        for (DailyWeeklyNotType type : values()) {
            String name = type.name();
            if (name.equals(typeName)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unbekannter Name '" + typeName + "'.");
    }

}
