package de.duehl.swing.text.html.data;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.Objects;

/**
 * Diese Klasse stellt einen im Text ersetzten Abschnitt dar.
 *
 * @version 1.01     2022-01-20
 * @author Christian Dühl
 */

public class HiddenMarkedHtmlPart {

    /** Das aus dem Text ausgeschnittene Stück. */
    private final String cutOut;

    /** Der dafür in den Text eingesetzte Platzhalter. */
    private final String placeHolder;

    /**
     * Konstruktor.
     *
     * @param cutOut
     *            Das aus dem Text ausgeschnittene Stück.
     * @param placeHolder
     *            Der dafür in den Text eingesetzte Platzhalter.
     */
    public HiddenMarkedHtmlPart(String cutOut, String placeHolder) {
        this.cutOut = cutOut;
        this.placeHolder = placeHolder;
    }

    /** Getter für das aus dem Text ausgeschnittene Stück. */
    public String getCutOut() {
        return cutOut;
    }

    /** Getter für den in den Text eingesetzten Platzhalter. */
    public String getPlaceHolder() {
        return placeHolder;
    }

    @Override
    public String toString() {
        return "HiddenMarkedHtmlPart [cutOut=" + cutOut + ", placeHolder=" + placeHolder + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(cutOut, placeHolder);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HiddenMarkedHtmlPart other = (HiddenMarkedHtmlPart) obj;
        return Objects.equals(cutOut, other.cutOut)
                && Objects.equals(placeHolder, other.placeHolder);
    }

}
