package de.duehl.swing.ui.buttons.painted;

import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Bewegen nach unten dar.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class DownButton extends PaintedButton {

    private static final long serialVersionUID = 1L;


    /** Konstruktor mit schwarzer Farbe. */
    public DownButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public DownButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet den kleinen Pfeil zum Starten. */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 3;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        int midHeight = firstUpperPixel + height / 2;
        int midWidth = firstLeftPixel + width / 2;

        if (isHorizontal()) {
            paintPolygon(
                    new PixelPoint(left,     upper),
                    new PixelPoint(midWidth, lower),
                    new PixelPoint(right,    upper)
                    );
        }
        else {
            paintPolygon(
                    new PixelPoint(right,  upper    ),
                    new PixelPoint(left,   midHeight),
                    new PixelPoint(right,  lower    )
                    );
        }
    }

}