package de.duehl.swing.ui.buttons.painted;

import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Schalten zum letzten Eintrag dar.
 * Eine quadratische Ansicht wird nicht unterstützt.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class LastButton extends PaintedButton {

    private static final long serialVersionUID = -1L;

    /** Konstruktor mit schwarzer Farbe. */
    public LastButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public LastButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintVerticalSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintVerticalSymbol();
    }

    /**
     * Zeichnet das Symbol in horizontaler Anordnung. isForceSquare() wird ignoriert.
     *
     *    1                   7--8
     *  6   .                 |  |
     *    .   .               |  |
     *       .   .            |  |
     *         .    .         |  |
     *           5     2      |  |
     *        .    .          |  |
     *      .   .             |  |
     *    .  .                |  |
     *  4   .                 |  |
     *    3                  10--9
     */
    private void paintHorizontalSymbol() {
        int delta = 6;       // Abstand von den Buttonkanten.
        int off = 4;         // Breite rechts.
        int xOff = 3;        // Abstand zwischen er linken oberen Delta-Ecke und Punkt 1.
        int yOff = 3;        // Abstand zwischen er linken oberen Delta-Ecke und Punkt 6.
        int middleOff = 7;   // Abstand zwischen Punkt 5 und Punkt 2
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;
        int hightCenter = getHeight() / 2;

        paintPolygon(
                new PixelPoint(left + xOff,              upper       ), //  1
                new PixelPoint(right - off,              hightCenter ), //  2
                new PixelPoint(left + xOff,              lower       ), //  3
                new PixelPoint(left,                     lower - yOff), //  4
                new PixelPoint(right - off - middleOff,  hightCenter ), //  5
                new PixelPoint(left,                     upper + yOff)  //  6
                );

        paintPolygon(
                new PixelPoint(right - off,  upper), //  7
                new PixelPoint(right,        upper), //  8
                new PixelPoint(right,        lower), //  9
                new PixelPoint(right - off,  lower)  // 10
                );
    }

    /**
     * Zeichnet das Symbol in vertikaler Anordnung. isForceSquare() wird ignoriert.
     *
     *     6                 4
     *   1   .            .    3
     *     .     .     .     .
     *        .     5     .
     *           .     .
     *              2
     *
     *  7-----------------------10
     *  |                        |
     *  8------------------------9
     */
    private void paintVerticalSymbol() {
        int delta = 6;       // Abstand von den Buttonkanten.
        int off = 4;         // Breite rechts.
        int xOff = 3;        // Abstand zwischen er linken oberen Delta-Ecke und Punkt 1.
        int yOff = 3;        // Abstand zwischen er linken oberen Delta-Ecke und Punkt 6.
        int middleOff = 7;   // Abstand zwischen Punkt 5 und Punkt 2
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;
        int widthCenter = getWidth() / 2;

        paintPolygon(
                new PixelPoint(left,          upper + yOff           ), //  1
                new PixelPoint(widthCenter,   lower - off            ), //  2
                new PixelPoint(right,         upper + yOff           ), //  3
                new PixelPoint(right - xOff,  upper                  ), //  4
                new PixelPoint(widthCenter,   lower - off - middleOff), //  5
                new PixelPoint(left + xOff,   upper                  )  //  6
                );

        paintPolygon(
                new PixelPoint(left,   lower - off), //  7
                new PixelPoint(left,   lower      ), //  8
                new PixelPoint(right,  lower      ), //  9
                new PixelPoint(right,  lower - off)  // 10
                );
    }

}
