package de.duehl.swing.ui.buttons.painted;

import java.awt.BasicStroke;


/**
 * Diese Klasse stellt einen kleinen Schalter dar, der anzeigt, ob eine Liste wiederholt wird.
 *
 * Die Zustände werden über das setzen der Farbe geregelt.
 *
 * @version 1.01     2025-07-26
 * @author Christian Dühl
 */

final public class LoopButton extends PaintedButton {

    private static final long serialVersionUID = 1L;

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /**
     * Zeichnet das Symbol. Da es dabei egal ist, ob horizontal oder vertikal, wird es in beiden
     * Fällen verwendet.
     */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 6;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        //int innerWidth = right - left;
        int innerHeight = lower - upper;

        int freeAreaY = innerHeight / 2;
        int yDelta = (int) (freeAreaY / 1.5);
        upper = upper + yDelta;
        lower = lower - yDelta;
        innerHeight = lower - upper;


        int radius = innerHeight / 2;

        int leftXUpperLeft = left; // Position des linken oberen Punktes des linken Halbkreises
        int leftYUpperLeft = upper;
        int diameter = 2 * radius; // Durchmesser

        // Linker Halbkreis:
        // startAngle = 90°, arcAngle = 180° (Zeichenrichtung im Uhrzeigersinn)
        graphics2.setStroke(new BasicStroke(3));
        graphics2.drawArc(leftXUpperLeft, leftYUpperLeft, diameter, diameter, 90, 180);

        int rightXUpperLeft = right - radius; // Position des linken oberen Punktes des rechten
        int rightYUpperLeft = upper;          // Halbkreises

        // Rechter Halbkreis:
        // startAngle = 270°, arcAngle = 180° (Zeichenrichtung im Uhrzeigersinn)
        graphics2.setStroke(new BasicStroke(3));
        graphics2.drawArc(rightXUpperLeft, rightYUpperLeft, diameter, diameter, 270, 180);

        int gap = 0; // irgendwie ist da von alleine einer...

        int x1Upper = left + radius;  // Startpunkt
        int y1Upper = upper; // Startpunkt
        int x2Upper = right - radius - gap; // Endpunkt
        int y2Upper = upper; // Endpunkt

        // Pfeillinie oben
        graphics2.drawLine(x1Upper, y1Upper, x2Upper, y2Upper);

        // Pfeilspitze zeichnen
        ShuffleButton.drawArrowHead(graphics2, x1Upper, y1Upper, x2Upper, y2Upper);

        int x1Lower = left + radius;  // Startpunkt
        int y1Lower = lower; // Startpunkt
        int x2Lower = right - radius + 5; // Endpunkt <------- da musste ich 5 Pixel hinzu tun
        int y2Lower = lower; // Endpunkt

        // Linie unten
        graphics2.drawLine(x1Lower, y1Lower, x2Lower, y2Lower);
    }

}
