package de.duehl.swing.ui.buttons.painted;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BasicStroke;
import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen Schalter zum Beenden von etwas dar.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class MinusInABoxButton extends PaintedButton {

    private static final long serialVersionUID = -1L;

    /** Konstruktor mit schwarzer Farbe. */
    public MinusInABoxButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public MinusInABoxButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Minus-Symbol Anordnung. */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 6;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        paintUnfilledRectangle(
                new PixelPoint(left,  upper),
                new PixelPoint(right, lower)
                );

        int midHeight = firstUpperPixel + height / 2;
        int deltaBox = Math.min(width, height)/10;
        paintLine(
                new PixelPoint(left + deltaBox,   midHeight),
                new PixelPoint(right - deltaBox,  midHeight)
                );
    }

    /** Setzt die Strichstärke. */
    @Override
    protected void setStroke() {
        graphics2.setStroke(new BasicStroke(1));
    }

}
