package de.duehl.swing.ui.colors;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

/**
 * Diese Klasse steht für die Farben eines Elements der grafischen
 * Benutzeroberfläche.
 *
 * @version 1.01     2013-10-30
 * @author Christian Dühl
 */

public class ElementColors {

    /** Vordergrundfarbe */
    private final Color foregroundColor;

    /** Hintergrundfarbe */
    private final Color backgroundColor;

    /**
     * Konstruktor
     *
     * @param foregroundColor
     *            Vordergrundfarbe
     * @param backgroundColor
     *            Hintergrundfarbe
     */
    public ElementColors(Color foregroundColor, Color backgroundColor) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
    }

    /** Getter für die Vordergrundfarbe. */
    public Color getForegroundColor() {
        return foregroundColor;
    }

    /** Getter für die Hintergrundfarbe. */
    public Color getBackgroundColor() {
        return backgroundColor;
    }

    @Override
    public String toString() {
        return "ElementColors [foregroundColor=" + foregroundColor
                + ", backgroundColor=" + backgroundColor + "]";
    }

}
