package de.duehl.swing.ui.components.selections;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.base.FileOrPathSelection;

/**
 * Diese Klasse stellt die Auswahl eines Verzeichnisses etwa in einem Optionendialog dar.
 *
 * @version 1.01     2018-01-04
 * @author Christian Dühl
 */

public class DirSelection extends FileOrPathSelection {

    /**
     *  Konstruktor.
     *
     * @param title Überschrift für die Wahl dieses Verzeichnisses.
     */
    public DirSelection(String title) {
        super(title);
    }

    /**
     * Der Benutzer wählt die Datei oder das Verzeichnis aus.
     *
     * @param startDir
     *            Startverzeichnis.
     * @return Ausgewählte Benutzereingabe oder null bei Abbruch durch den Benutzer.
     */
    @Override
    protected String openPath(String startDir) {
        return GuiTools.openDirectory(startDir);
    }

}
