package de.duehl.swing.ui.dialogs.lists.logic;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für eine Liste von Datenelementen, welche in einem EditableListDialog
 * angezeigt, bearbeitet, gelöscht, umsortiert oder neu hinzugefügt werden sollen.
 *
 * @version 1.02     2021-11-18
 * @author Christian Dühl
 */

public interface LogicalEditableList<Element extends LogicalEditableListElement>
    extends Iterable<Element> {

    /** Gibt an, ob das übergebene Element in der Liste enthalten ist. */
    boolean contains(Element element);

    /**
     * Prüft, ob das übergebene Element zur Liste hinzugefügt werden kann.
     *
     * Standardmäßig wird geprüft, ob das Element bereits in der Liste enthalten ist.
     * Kann für weitere oder auch weniger Prüfungen überschrieben werden.
     *
     * @param element
     *            Zu überprüfendes Element.
     * @return Wahrheitswert.
     */
    boolean canWeAdd(Element element);

    /** Fügt ein Element hinzu. */
    void add(Element element);

    /**
     * Entfernt das übergebene Element aus der Liste.
     *
     * Wirft eine Ausnahme, falls das Element nicht in der Liste enthalten ist.
     */
    void remove(Element element);

    /** Gibt an, ob das übergebene Element nach oben zu bewegen ist. */
    boolean canMoveUp(Element element);

    /** Bewegt das übergebene Element einen Platz in der Liste aufwärts, falls möglich. */
    void moveUp(Element element);

    /** Gibt an, ob das übergebene Element nach unten zu bewegen ist. */
    boolean canMoveDown(Element element);

    /** Bewegt das übergebene Element einen Platz in der Liste abwärts, falls möglich. */
    void moveDown(Element element);

    /** Gibt an, ob das übergebene Element mindestens zweimal in der Liste enthalten ist. */
    boolean containedMoreThanOnce(Element element);

    /** Leert die Liste. */
    void clear();

}
