package de.duehl.swing.ui.elements;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

import javax.swing.JTextArea;

/**
 * Dieses Klasse erweitert eine JTextArea so, dass es seine Hintergrundfarbe
 * abhängig davon wechselt, ob Inhalt dargestellt wird oder nicht..
 *
 * @version 1.01     2015-01-29
 * @author Christian Dühl
 */

public class AutoBackgroundTextAres extends JTextArea {

    private static final long serialVersionUID = 8467308271577556176L;

    /** Hintergrundfarbe für gefüllten Zustand. */
    private final Color filledBackgroundColor;

    /** Hintergrundfarbe für leeren Zustand. */
    private final Color emptyBackgroundColor;

    /**
     * Konstruktor.
     *
     * @param filledBackgroundColor
     *            Hintergrundfarbe für gefüllten Zustand.
     * @param emptyBackgroundColor
     *            Hintergrundfarbe für leeren Zustand.
     */
    public AutoBackgroundTextAres(final Color filledBackgroundColor,
            final Color emptyBackgroundColor) {
        super();
        this.filledBackgroundColor = filledBackgroundColor;
        this.emptyBackgroundColor = emptyBackgroundColor;
        setBackground(emptyBackgroundColor);
    }

    /**
     * Setzt den anzuzeigenden Text und wählt abhängig davon, ob dieser gefüllt
     * ist, die Hintergrundfarbe des Textfeldes.
     *
     * @param text
     *            Anzuzeigender Text.
     */
    @Override
    public void setText(final String text) {
        super.setText(text);
        if (text.isEmpty()) {
            setBackground(emptyBackgroundColor);
        }
        else {
            setBackground(filledBackgroundColor);
        }
    }

}
