package de.duehl.swing.ui.filefilter;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * Diese Klasse stellt einen FileFilter für einen JFileChooser dar, der Zip-Dateien selektiert.
 *
 * @version 1.01     2016-07-12
 * @author Christian Dühl
 */

public class ZipFileFilter extends FileFilter {

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (f.getName().toLowerCase().endsWith(".zip")) {
            return true;
        }
        else {
            return false;
        }
    }

    @Override
    public String getDescription() {
        return "Zip-Dateien (*.zip)";
    }

}
