package de.duehl.swing.ui.highlightingeditor.userinput;

import javax.swing.event.DocumentListener;

/**
 * Dieses Interface stellt die Verbindung vom Editor zu der Klasse dar, die bei
 * Benutzereingaben auf deren Ende wartet, bevor das Syntax-Highlighting durchgeführt wird.
 *
 * @version 1.01     2017-12-19
 * @author Christian Dühl
 */

public interface EditorForReactAfterUserInput {

    /** Fügt dem Editor einen DocumentListener hinzu. */
    void addDocumentListener(DocumentListener lister);

    /** Zeigt an, dass das Dokument geändert worden ist. */
    void signChangedState();

    /** Reagiert darauf, das vor einiger Zeit Benutzereingaben stattfanden. */
    void reactAfterUserInput();

}
