package de.duehl.swing.ui.menu.collection;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

/**
 * Diese Klasse sammelt automatisch die gemerkten Eigenschaften von der Menüeinträgen eines Projekts.
 *
 * @version 1.01     2020-08-20
 * @author Christian Dühl
 */

public class AutomaticMyMenuItemCollection {

    /** Statische Sammlung aller im Projekt hinterlegten Menüeinträge. */
    private static final MyMenuItemCollection COLLECTION = new MyMenuItemCollection();

    /** Sammelt den übergebenen Menüeintrag. */
    public static void collect(StoredMyMenuItem storedMyMenuItem) {
        COLLECTION.collect(storedMyMenuItem);
    }

    /**
     * Überprüft die Tastenbelegung dieses Menüeintrags auf das bereits Vorhandensein bei anderen
     * Menüeinträgen.
     *
     * Hier befindet sich das übergebene Objekt bereits in der Liste, daher wird es natürlich nicht
     * mit sich selbst verglichen!
     */
    public static void checkAccelerator(StoredMyMenuItem storedMyMenuItem) {
        COLLECTION.checkAccelerator(storedMyMenuItem);
    }


    /** Schaltet die automatische Sammlung von Menüeinträgen ab. */
    public static void switchOffMyMenuItemCollection() {
        COLLECTION.switchOffMyMenuItemCollection();
    }

    /**
     * Schaltet die automatische Sammlung von Menüeinträgen an (nur sinnvoll, falls vorher selbst
     * abgeschaltet).
     */
    public static void switchOnMyMenuItemCollection() {
        COLLECTION.switchOnMyMenuItemCollection();
    }

    /** Entfernt alle bisher gemerkten Menüeinträge. */
    public static void clearCollection() {
        COLLECTION.clearCollection();
    }

    /** Getter für die statische Liste aller im Projekt hinterlegten Menüeinträge. */
    public static List<StoredMyMenuItem> getListOfCollectedMyMenuItems() {
        return COLLECTION.getListOfCollectedMyMenuItems();
    }

}
