package de.duehl.swing.ui.text.autocompletion;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Enum-Klasse steht für eine Taste, mit der die Autovervollständigung ausgelöst wird.
 *
 * @version 1.01     2020-06-05
 * @author Christian Dühl
 */

public enum AutoCompletionKey {

    ENTER("ENTER", "\n"),
    SPACE("SPACE", " "),
    ;

    /** String zur Ermittlung des richtigen KeyStrokes mit KeyStroke.getKeyStroke(). */
    private final String keyStrokeString;

    /** Text der eingefügt werden soll, falls nicht die Autovervollständigung bestätigt wird. */
    private final String textInsertionNotInAutocompleteMode;

    /**
     * Konstruktor.
     *
     * @param keyStrokeString
     *            String zur Ermittlung des richtigen KeyStrokes mit KeyStroke.getKeyStroke().
     * @param textInsertionNotInAutocompleteMode
     *            Text der eingefügt werden soll, falls nicht die Autovervollständigung bestätigt
     *            wird.
     */
    private AutoCompletionKey(String keyStrokeString, String textInsertionNotInAutocompleteMode) {
        this.keyStrokeString = keyStrokeString;
        this.textInsertionNotInAutocompleteMode = textInsertionNotInAutocompleteMode;
    }

    /**
     * Getter für den String zur Ermittlung des richtigen KeyStrokes mit KeyStroke.getKeyStroke().
     */
    public String getKeyStrokeString() {
        return keyStrokeString;
    }

    /**
     * Getter für den Text der eingefügt werden soll, falls nicht die Autovervollständigung
     * bestätigt wird.
     */
    public String getTextInsertionNotInAutocompleteMode() {
        return textInsertionNotInAutocompleteMode;
    }

}
