package de.duehl.swing.ui.colors;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

public class ColoratorTest {

    @Test
    public void getColors() {
        Colorator colorator = new Colorator() {
            @Override
            protected void initColorSequenze() {
                addColor("red");
                addColor("blue");
                addColor("green");
            }
        };
        List<String> list = colorator.getColors();
        assertEquals(3, list.size());
        assertEquals("red", list.get(0));
        assertEquals("blue", list.get(1));
        assertEquals("green", list.get(2));
    }

}
