package de.duehl.swing.ui.start;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import javax.swing.JFrame;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.panel.JPanelButton;
import de.duehl.swing.ui.buttons.panel.PanelButtonClickReactor;

public class JPanelButtonTest implements PanelButtonClickReactor {

    private void run() {

        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setTitle("JPanel als Button");

        JPanelButton panel = new JPanelButton((PanelButtonClickReactor) this);

        frame.setContentPane(panel);
        frame.setSize(300, 150);
        frame.setVisible(true);
    }

    @Override
    public void userHasClicked() {
        System.out.println("Der Benutzer hat den Button geklickt.");
    }

    public static void main(final String[] args) {
        GuiTools.setNiceLayoutManager();
        new JPanelButtonTest().run();
    }

}
