package de.duehl.swing.ui.start;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

import de.duehl.swing.ui.GuiTools;

/*
 * Frei nach
 * https://stackoverflow.com/questions/5853879/swing-obtain-image-of-jframe
 */

public class ScreenshotTest {

    private static final String HELP = "Type Ctrl-0 to get a screenshot of the current GUI.\n"
            + "The screenshot will be saved to the current " + "directory as 'screenshot.png'.";

    public static void main(String[] args) {
        Runnable r = new Runnable() {
            @Override
            public void run() {
                JFrame frame = new JFrame("Test Screenshot");

                JMenuItem screenshot = new JMenuItem("Screenshot");
                screenshot.setAccelerator(
                        KeyStroke.getKeyStroke(KeyEvent.VK_0, InputEvent.CTRL_DOWN_MASK));
                screenshot.addActionListener(e ->
                        GuiTools.takeScreenshot(frame, "c:\\Users\\setup\\.Pot1\\screenshot2.png"));
                JMenu menu = new JMenu("Other");
                menu.add(screenshot);
                JMenuBar menuBar = new JMenuBar();
                menuBar.add(menu);
                frame.setJMenuBar(menuBar);

                JPanel p = new JPanel(new BorderLayout(5, 5));
                p.setBorder(new TitledBorder("Main GUI"));
                p.add(new JScrollPane(new JTree()), BorderLayout.WEST);
                p.add(new JScrollPane(new JTextArea(HELP, 10, 30)), BorderLayout.CENTER);

                frame.setContentPane(p);
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                frame.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

}
