package de.duehl.swing.ui.start.listdialog;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;
import java.awt.Point;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.lists.SelectFromEditableListDialog;
import de.duehl.swing.ui.dialogs.lists.ui.EditableListElement;
import de.duehl.swing.ui.start.listdialog.logic.DemoLogicalElement;
import de.duehl.swing.ui.start.listdialog.logic.DemoLogicalList;
import de.duehl.swing.ui.start.listdialog.ui.DemoUiElement;

public class SelectFromEditableListDialogDemo
        extends SelectFromEditableListDialog<DemoLogicalElement> {

    private static final Dimension DIALOG_DIMENSION = new Dimension(600, 500);

    public SelectFromEditableListDialogDemo(DemoLogicalList logicalList) {
        super(DIALOG_DIMENSION, new Point(400, 350), null, "Demo-Titel", logicalList);

        fillDialog();
    }

    @Override
    protected EditableListElement<DemoLogicalElement> createUiElement(DemoLogicalElement element) {
        return new DemoUiElement(element, getLogicalList(), this);
    }

    public static void main(String[] args) {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        list.add(new DemoLogicalElement("Ananas"));
        list.add(new DemoLogicalElement("Kiwi"));
        list.add(new DemoLogicalElement("Tomate"));
        list.add(new DemoLogicalElement("Banane"));
        list.add(new DemoLogicalElement("Olive"));
        list.add(new DemoLogicalElement("Gurke"));
        list.add(new DemoLogicalElement("Mandarine"));
        list.add(new DemoLogicalElement("Melone"));
        list.add(new DemoLogicalElement("Erdbeere"));
        list.add(new DemoLogicalElement("Blaubeere"));
        list.add(new DemoLogicalElement("Brombeere"));
        list.add(new DemoLogicalElement("Erbse"));
        list.add(new DemoLogicalElement("Bohne"));
        list.add(new DemoLogicalElement("Brokkolie"));
        list.add(new DemoLogicalElement("Blumenkohl"));
        list.add(new DemoLogicalElement("Paprika"));

        GuiTools.setNiceLayoutManager();

        SelectFromEditableListDialogDemo dialog = new SelectFromEditableListDialogDemo(list);
        dialog.setVisible(true);
        if (dialog.hasUserSelected()) {
            DemoLogicalElement element = dialog.getUserSelection();
            System.out.println("Wahl des Benutzers: " + element.getText());
        }
        else {
            System.out.println("Abbruch der Auswahl durch den Benutzer.");
        }
        System.out.println("Änderungen: " + dialog.isDataChanged()); // kann nicht true sein!
    }

}
