package de.duehl.swing.ui.start.search;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;

import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.elements.search.SearchPanel;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditorWithoutButtonBar;
import de.duehl.swing.ui.highlightingeditor.search.EditorSearcher;

/**
 * Diese Klasse testet das EnterTextField-Element.
 *
 * @version 1.01     2017-12-15
 * @author Christian Dühl
 */

public class SearchPanelDemoWithEditorAndSearcher {

    private final HighlightingEditor editor;

    /** Sucht in dem Editor. */
    private final EditorSearcher editorSearcher;

    /** Das zu testende Suchfeld. */
    private SearchPanel searchPanel;

    /** Konstruktor. */
    public SearchPanelDemoWithEditorAndSearcher() {
        editor = new HighlightingEditorWithoutButtonBar();
        editor.setText(Text.loremImpsum());
        editorSearcher = new EditorSearcher(editor);

        searchPanel = new SearchPanel(editorSearcher.createSearchReaktor());

        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("SearchPanel Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(searchPanel, BorderLayout.NORTH);
        frame.add(editor.getComponent(), BorderLayout.CENTER);

        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setVisible(true);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new SearchPanelDemoWithEditorAndSearcher();
    }

}

