package de.duehl.swing.ui.start.update;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.update.UpdateGui;
import de.duehl.swing.ui.update.UpdateLogic;

public class UpdateTestLogic implements Quitter {

    private final UpdateTestGui gui;

    private UpdateLogic updateLogic;

    public UpdateTestLogic() {
        gui = new UpdateTestGui(this);
    }

    public void createUpdateLogic(UpdateGui updateGui) {
        updateLogic = new UpdateLogic(createJob(), "Dummy-Job", updateGui, 10, 1, 24 * 60 * 60 * 7);
    }

    private Runnable createJob() {
        return new Runnable() {
            @Override
            public void run() {
                SystemTools.sleepSeconds(2);
            }
        };
    }

    public void run() {
        gui.setVisible(true);
        gui.updateNow();
    }

    @Override
    public void quit() {
        updateLogic.quit();
        gui.quit();
    }

    public static void main(String[] args) {
        UpdateTestLogic logic = new UpdateTestLogic();
        logic.run();
    }

}
