package de.duehl.twosidecommander.ui.list.data;

import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;

/**
 * Dieses Interface steht für eine Klasse, die auf die Buttons zum vertikalen Verschieben des
 * Listenelements reagiert.
 *
 * @version 1.01     2025-06-18
 * @author Christian Dühl
 */

public interface ListElementMoveReactor {

    /** Gibt an, ob die nutzende Ui das Element mit diesen Buttons nach oben bewegt werden kann. */
    boolean canListElementMoveUp(ListElementDisplayer displayer);

    /** Gibt an, ob die nutzende Ui das Element mit diesen Buttons nach unten bewegt werden kann. */
    boolean canListElementMoveDown(ListElementDisplayer displayer);

    /** Verschiebt das Element mit diesen Buttons an die erste Stelle. */
    void moveListElementToFirst(ListElementDisplayer displayer);

    /** Verschiebt das Element mit diesen Buttons nach oben. */
    void moveListElementUp(ListElementDisplayer displayer);

    /** Verschiebt das Element mit diesen Buttons nach unten. */
    void moveListElementDown(ListElementDisplayer displayer);

    /** Verschiebt das Element mit diesen Buttons an die letzte Stelle. */
    void moveListElementToLast(ListElementDisplayer displayer);

}
