package de.duehl.vocabulary.japanese.common.color.data;

/**
 * Diese Klasse stellt die Anzahl aller und die Anzahl aller richtig beantworeter tests dar.
 *
 * @version 1.01     2024-07-25
 * @author Christian Dühl
 */

public class TotalAndCorrectTotalCount {

    /** Die Anzahl aller Abfragen. */
    private final int total;

    /** Die Anzahl der richtig beantworteten Abfragen. */
    private final int correct;

    /**
     * Konstruktor.
     *
     * @param total
     *            Die Anzahl aller Abfragen.
     * @param correct
     *            Die Anzahl der richtig beantworteten Abfragen.
     */
    public TotalAndCorrectTotalCount(int total, int correct) {
        this.total = total;
        this.correct = correct;
    }

    /** Getter für die Anzahl aller Abfragen. */
    public int getTotal() {
        return total;
    }

    /** Getter für die Anzahl der richtig beantworteten Abfragen. */
    public int getCorrect() {
        return correct;
    }

    @Override
    public String toString() {
        return "TotalAndCorrectTotalCount [total=" + total + ", correct=" + correct + "]";
    }

}
